# UCDP Battle-related deaths / Conflictintensinty
load("Daten/UCDP Battle-Related Deaths Dataset 1989-2013/124934_1ucdpbattle-relateddeathsdatasetv.5-2014conflict.rdata")

ucdpBRDConf <- subset(ucdpBRDConf, select = c(ConflictID, Year, BdBest))
ucdpBRDConf <- rename(ucdpBRDConf, c("Year" = "year", "ConflictID" = "conflictid", "BdBest" = "BattleDeaths"))

# from dplyr help: << type="left": all rows in x, adding matching columns from y >>
Master <- join(Master, ucdpBRDConf, type="left", by=c("conflictid", "year"), match="all")
Master$BattleDeaths[is.na(Master$BattleDeaths)] <- 0 # replace all NA with 0 (no report = no battle-deaths; don't loose cases)

# create logarithmic version
Master$BattleDeaths.log <- log(Master$BattleDeaths, )
Master$BattleDeaths.log[is.infinite(Master$BattleDeaths.log)] <- 0

rm(ucdpBRDConf)